function  [params,residual]= FitPDF(r,pdf,mu,sigma,xi)
%  The spatial dimension.
   d = 2;
%  Estimate the second moment.
   s = 30;
options=optimset('MaxFunEvals',100000,...
    'MaxIter',100000,...
    'TolFun',1e-8,...
    'TolX',1e-7,...
    'Display','iter');
  
%  The general Weibull fit.
%  s = params(1);
%  d = params(2);
   F = @(params,r,pdf) sum((PDFWeibull(r,params) - pdf).^2);
%  Initial guess for the minimization.
   params1 =[s,d];
%  Least squares fit.
   params1 = fminsearch(@(params1) F(params1,r,pdf),params1);
   residual1 = norm(F(params1,r,pdf));

% The Chi fit.
%  s = params(1);
%  d = params(2);
   F = @(params,r,pdf) sum((PDFChi(r,params) - pdf).^2);
%  Initial guess for the minimization.
   params2 = [s, d];
%  Least squares fit.
   params2 = fminsearch(@(params2) F(params2,r,pdf),params1);
   residual2 = norm(F(params2,r,pdf));

% The Long-Short fit.
%  s = params(1);
%  a = params(2);
%  b = params(3)
   F = @(params,r,pdf) sum((PDFLS(r,params) - pdf).^2);
%  Initial guess for the minimization.
   params3 = [10,1/2,2];
%  Least squares fit.
   params3 = fminsearch(@(params3) F(params3,r,pdf),params3);
   residual3 = norm(F(params3,r,pdf));

%  The GEV fit
%  sigma = params(1);
%  xi = params(2);
%  mu = params(3);
   F = @(params,r,pdf) sum((PDFGEV(r,params) - pdf).^2);
%  Initial guess for the minimization.
   params4 = [sigma,xi, mu];
%  Least squares fit.
   params4 = fminsearch(@(params4) F(params4,r,pdf),params4);
   residual4 = norm(F(params4,r,pdf));
%
%  Accumulate the parameters.
   params = [params1, params2, params3, params4];
   residual = [residual1, residual2, residual3, residual4];
